#include <unistd.h>
#include "vehicle/bus.h"
#include "log/log.h"

/*******************
 *
 * Goal: Print mean value (based on the last 10 values) of engine
 * speed (approx.) every second.
 *
 * We'll break this goal down to three smaller tasks, and these into
 * even smaller sub tasks. The sub tasks are close to pseudo code and
 * should, given some thoughts, be possible to translate in to C code
 * - sometimes using one line of code and sometimes using a few lines.
 *
 * You need to find a good place to do place the C code. We will give
 * some hint though.
 *
 * Tasks:
 *
 * 1) Store the value (either the entire struct or just the engine
 *    speed) in an array - store only the last 10 values/structs
 *    1.1) declare an array
 *    1.2) make sure the data is valid (check the return value)
 *    1.3) if not 10 items, store this item
 *         if 10 items, discard the first and store the new item
 *
 * 2) Check if 1 sec has passed since last print out
 *    2.1) declare variables previous_time and current_time (find a suitable type)
 *    2.2) check if previous_time - current_time > 1 sec 
 *    2.3) if the above (2.2) is true store current_time in previous_time
 * 
 * 3) Calc the mean value 
 *    3.1) If one sec has passed (see (2)), calculate mean value of 10
 *         last values of engine_speed and print out the mean value
 *    3.2) If one sec has not passed, do nothing
 *
 ***************************/


int main() {

  vehicle_info vi;
  /* 1.1 and 2.1 */
  int array[10];
  int i;
  int retval;
  int array_init_count = 0;
  struct timeval previous_time;
  struct timeval current_time;
  long sec_diff;
  long usec_diff;
  float mean;
  long time_diff;

  /*
   * variable init
   *
   */
  mean = 0;
  previous_time.tv_sec = 0;
  previous_time.tv_usec = 0;
  
  while (1) {


    /*  Debug printout - only seen with
     *   make clean debug 
     */
    debug(("Getting new data\n"));

    retval = get_bus_data(&vi);
    debug(("Retval: %d\n", retval)); 
    /* 1.2 and 1.3 */
    if (retval != 0)
      {
	debug(("Data Invalid!\n"));
      }
    else if (array_init_count < 10)
      {
	array[array_init_count] = vi.engine_speed;
	array_init_count++;
      }
    else
      {
	for(i = 0; i < 9; i++)
	  {
	    array[i] = array[i + 1];
	  }
	array[9] = vi.engine_speed;
      
	/* for(i = 0; i < 10; i++) */
	/*   printf("%d\n", array[i]); */
      }
   
    /* Log the data - only seen with either
     *   make clean log
     *   make clean debug 
     */
    log_vehicle_info(&vi);
    
    
    gettimeofday(&current_time, NULL); 
    
    sec_diff = current_time.tv_sec - previous_time.tv_sec;
    usec_diff = current_time.tv_usec - previous_time.tv_usec;
    time_diff = sec_diff*1000000 + usec_diff;
    
    if (time_diff  >= 1000000)
      {
	previous_time.tv_sec = current_time.tv_sec;
	previous_time.tv_usec = current_time.tv_usec;
	
	/*
	 * Print mean if we are certain array contains 10 elements
	 */
	if (array_init_count > 9)
	  {
	    for (i = 0; i < 10; i++)
	      {
		mean += array[i];
	      }
	    mean = mean / 10;
	    fprintf(stdout, "Mean engine speed: %.2f\n", mean);
	  }
      }
    /* Sleep for 100 useconds, that is 1/10 of second */
    usleep(1000*100);
    
  }
  
  return 0;
}
